//-----------------------------------------------------------------------------
// GravityChooserProgram.cs
// (A. Schiffler, 2009-2011)
//-----------------------------------------------------------------------------

namespace GravityChooser
{
    using System;

    /// <summary>
    /// Main game program.
    /// </summary>
    static class GravityChooserProgram
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        static void Main()
        {
            bool fullscreen = false;
            string[] args = System.Environment.GetCommandLineArgs();
            if ((args.Length == 2) && (!string.IsNullOrEmpty(args[1])))
            {
                if (args[1].Equals("/fullscreen"))
                {
                    fullscreen = true;
                }
            }

            using (GravityChooser game = new GravityChooser(fullscreen))
            {
                game.Run();
            }
        }
    }
}

