#region File Description
//-----------------------------------------------------------------------------
// GravityChooserBackgroundScreen.cs
// (A. Schiffler, 2009-2011)
//-----------------------------------------------------------------------------
#endregion

namespace GravityChooser
{
    using System;
    using Microsoft.Xna.Framework;
    using Microsoft.Xna.Framework.Content;
    using Microsoft.Xna.Framework.Graphics;
    using NewGamePhysics.StateManager;
    
    /// <summary>
    /// Background screen for gravity chooser.
    /// </summary>
    class GravityChooserBackgroundScreen : GameScreen
    {
        #region Fields

        /// <summary>
        /// The content manager
        /// </summary>
        ContentManager contentManager;

        /// <summary>
        /// The background texture.
        /// </summary>
        Texture2D backgroundTexture;

        #endregion

        #region Initialization

        /// <summary>
        /// Constructor for the GravityChooserBackgroundScreen.
        /// </summary>
        public GravityChooserBackgroundScreen()
        {
            TransitionOnTime = TimeSpan.FromSeconds(0.5);
            TransitionOffTime = TimeSpan.FromSeconds(0.5);
        }

        /// <summary>
        /// Loads graphics content for the GravityChooserBackgroundScreen.
        /// </summary>
        public override void LoadContent()
        {
            if (contentManager == null)
            {
                contentManager = new ContentManager(ScreenManager.Game.Services, "Content");
            }

            backgroundTexture = contentManager.Load<Texture2D>(@"Sprites\background");
        }

        /// <summary>
        /// Unloads graphics content for the GravityChooserBackgroundScreen.
        /// </summary>
        public override void UnloadContent()
        {
            contentManager.Unload();
        }

        #endregion

        #region Update and Draw

        /// <summary>
        /// Updates the background screen.
        /// </summary>
        public override void Update(GameTime gameTime, bool otherScreenHasFocus,
                                                       bool coveredByOtherScreen)
        {
            base.Update(gameTime, otherScreenHasFocus, false);
        }

        /// <summary>
        /// Draws the background screen.
        /// </summary>
        public override void Draw(GameTime gameTime)
        {
            SpriteBatch spriteBatch = ScreenManager.SpriteBatch;
            Viewport viewport = ScreenManager.GraphicsDevice.Viewport;
            Rectangle fullscreen = new Rectangle(0, 0, viewport.Width, viewport.Height);
            byte fade = TransitionAlpha;

            spriteBatch.Begin(SpriteBlendMode.None);

            spriteBatch.Draw(backgroundTexture, fullscreen,
                             new Color(fade, fade, fade));

            spriteBatch.End();
        }

        #endregion
    }
}
