//-----------------------------------------------------------------------------
// MontyHallGame.cs
// (C) A. Schiffler, 2009-2011
//-----------------------------------------------------------------------------

namespace MontyHallGame
{
    using System.Threading;
    using System.Collections.Generic;
    using Microsoft.Xna.Framework;
    using Microsoft.Xna.Framework.Audio;
    using Microsoft.Xna.Framework.Content;
    using Microsoft.Xna.Framework.GamerServices;
    using Microsoft.Xna.Framework.Graphics;
    using Microsoft.Xna.Framework.Input;
    using Microsoft.Xna.Framework.Net;
    using Microsoft.Xna.Framework.Storage;

    using NewGamePhysics;
    using NewGamePhysics.Mathematics;
    using NewGamePhysics.Physics;
    using NewGamePhysics.Utilities;
    using NewGamePhysics.StateManager;

    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class MontyHallGame : Microsoft.Xna.Framework.Game
    {
        /// <summary>
        /// The current game state.
        /// </summary>
        public static MontyHallGameState state = new MontyHallGameState();

        // Graphics
        GraphicsDeviceManager graphics;
        ScreenManager screenManager;
        Viewport viewport;
        Matrix projectionMatrix;

        // Inputs
        Gamepads gamepads;

        /// <summary>
        /// Constructor of game.
        /// </summary>
        /// <param name="fullscreen">Enable fullscreen mode if flag set.</param>
        public MontyHallGame(bool fullscreen)
        {
            // New input object
            gamepads = new Gamepads();

            // Content root
            Content.RootDirectory = "Content";

            // Prefer a resolution suitable for both Windows and XBox 360
            graphics = new GraphicsDeviceManager(this);
            graphics.PreferredBackBufferWidth = 853;
            graphics.PreferredBackBufferHeight = 480;

            // Maybe enable fullscreen
            graphics.IsFullScreen = fullscreen;

            // Enable antialiasing
            graphics.PreferMultiSampling = true;

            // Create the screen manager component.
            screenManager = new ScreenManager(this);
            Components.Add(screenManager);
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // Current viewport
            viewport = graphics.GraphicsDevice.Viewport;

            // Enable mouse
            this.IsMouseVisible = true;

            // Aspect ratio
            float aspectRatio = graphics.GraphicsDevice.Viewport.Width /
                (float)graphics.GraphicsDevice.Viewport.Height;

            // Create the projection matrix.
            projectionMatrix = Matrix.CreatePerspectiveFieldOfView(
                MathHelper.ToRadians(45.0f), aspectRatio, 1f, 10000);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Load textures
            string[] doorFilenames = {
                                        "mdoor_ccc", "mdoor_cco", "mdoor_coc", "mdoor_coo",
                                        "mdoor_occ", "mdoor_oco", "mdoor_ooc", "mdoor_ooo"
                                    };
            foreach (string doorFilename in doorFilenames)
            {
                screenManager.AddTexture(doorFilename, "Textures/" + doorFilename);
            }

            // Load sprites
            screenManager.AddTexture("key", "Sprites/key");
            screenManager.AddTexture("opensign", "Sprites/opensign");
            screenManager.AddTexture("monty", "Sprites/monty");
            screenManager.AddTexture("potogold", "Sprites/potogold");

            // Load fonts
            screenManager.AddFont("courier", "Fonts/courier");
            screenManager.AddFont("retro", "Fonts/retroMedium");

            // Create sounds
            screenManager.AddSound("door", "Sounds/door");
            screenManager.AddSound("crowd", "Sounds/gameshow_crowd");
            screenManager.AddSound("show", "Sounds/gameshow");
            screenManager.AddSound("intro", "Sounds/intro_jingle");
            screenManager.AddSound("loser", "Sounds/loser");
            screenManager.AddSound("money", "Sounds/money");
            screenManager.AddSound("winner", "Sounds/pick_a_winner");
            screenManager.AddSound("click", "Sounds/click");

            // Activate the first screens.
            screenManager.AddScreen(new MontyHallBackgroundScreen(), null);
            screenManager.AddScreen(new MontyHallMainMenuScreen(), null);
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Keyboard state
            KeyboardState keyState = Keyboard.GetState();
            Keys[] keys = keyState.GetPressedKeys();

            // Allows the game to exit
            if (keyState.IsKeyDown(Keys.Delete))
            {
                this.Exit();
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            // Clear to black
            graphics.GraphicsDevice.Clear(Color.Black);

            // Redraw
            base.Draw(gameTime);
        }
    }
}
