// Apply chromakey on a particular reference color using
// a step transition at threshold value

sampler TextureSampler : register(s0);

float3 referenceColor;
float threshold;

float4 PixelShader(float2 texCoord: TEXCOORD0) : COLOR
{
	float3 color = tex2D(TextureSampler, texCoord);
	float alpha = 1.0f;
	float distance = distance(color, referenceColor);
	if (distance < threshold)
	{
		alpha = 0.0f;
	}
		
	float4 newcolor = float4(color.r, color.g, color.b, alpha);
	return newcolor;
}
technique
{
	pass P0
	{
		PixelShader = compile ps_2_0 PixelShader();
	}
}

