// Pixel shader which combines a source image and the base scene
// using green countours based on the source intensity

sampler CombineSampler : register(s0);
sampler BaseSampler : register(s1);

float ContourFrequency;

float4 PixelShader(float2 texCoord : TEXCOORD0) : COLOR0
{
    // Look up the source and base colors
    float3 color = tex2D(CombineSampler, texCoord);
    float4 base = tex2D(BaseSampler, texCoord);
       
    // Get brightness
	float grey = dot(color, float3(0.212671f, 0.715160f, 0.072169f));
	grey = clamp(grey, 0, 1);
	
	// Modulate contours using a sin function
	float value = grey * ContourFrequency;
	value = sin(value) * sqrt(grey);
	value = 0.5f * clamp(value, 0, 1);
    float4 newcolor = float4(0.0f, value, 0.0f, 1.0f);
    
    // Combine the pixels
    return base + newcolor ;
}
technique
{
	pass P0
    {
        PixelShader = compile ps_2_0 PixelShader();
    }
}
