// Pixel shader applies a 2D laplace filter

sampler TextureSampler : register(s0);

#define SAMPLE_COUNT 4

float2 TapOffsets[SAMPLE_COUNT];

float4 PixelShader(float2 texCoord : TEXCOORD0) : COLOR0
{
    float4 c = 0;
    
    // Combine source pixels from taps
    for (int i = 0; i < SAMPLE_COUNT; i++)
    {
        c += tex2D(TextureSampler, texCoord + TapOffsets[i]);
    }
    
    // Average
    c /= 4.0f;
    
    return c;
}
technique
{
	pass P0
    {
        PixelShader = compile ps_2_0 PixelShader();
    }
}