// Pixel shader to threshold a pixel and rescale to 0.0 - 1.0
// Values less than the threshold are set to 0.0, values more than
// the threshold are rescaled to the 0.0 - 1.0 range.

sampler TextureSampler : register(s0);

float threshold;

float4 PixelShader(float2 texCoord : TEXCOORD0) : COLOR0
{
 float4 color = tex2D(TextureSampler, texCoord);
 
 return saturate((color - threshold) / (1.0f - threshold));
}
technique
{
	pass P0
	{
		PixelShader = compile ps_2_0 PixelShader();
	}
}
