﻿//-----------------------------------------------------------------------------
// InfoLink.cs
// (A. Schiffler, 2009)
//-----------------------------------------------------------------------------

namespace NewGamePhysics.Networking
{
    using System;

    using NewGamePhysics.Utilities;

    /// <summary>
    /// Class encapsulating an info link, a labeled URL.
    /// </summary>
    public class InfoLink
    {
        /// <summary>
        /// The category for this InfoLink.
        /// </summary>
        public string Category;

        /// <summary>
        /// The category for this InfoLink.
        /// </summary>
        public string SubCategory;

        /// <summary>
        /// The title of the InfoLink.
        /// </summary>
        public string Title;

        /// <summary>
        /// The URL of this InfoLink.
        /// </summary>
        public SerializableUri Uri;

        /// <summary>
        /// Parameterless constructor.
        /// </summary>
        public InfoLink()
        {
            this.Category = string.Empty;
            this.SubCategory = string.Empty;
            this.Title = string.Empty;
            this.Uri = null;
        }

        /// <summary>
        /// Create info link object.
        /// </summary>
        /// <param name="category">The category.</param>
        /// <param name="subCategory">The sub category.</param>
        /// <param name="title">The title/name.</param>
        /// <param name="uri">The URL to point to.</param>
        public InfoLink(string category, string subCategory, string title, Uri uri)
        {
            this.Category = category;
            this.SubCategory = subCategory;
            this.Title = title;
            this.Uri = uri;
        }

        /// <summary>
        /// Returns string representation of info link
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return string.Format("Category:{0} Subcategory:{1} Title:{2} Url:{3}", 
                this.Category, 
                this.SubCategory, 
                this.Title, 
                this.Uri.ToString());
        }
    }
}
