﻿// --------------------------------------------------------
// AirDensity.cs
// (A. Schiffler, 2009)
// --------------------------------------------------------

namespace NewGamePhysics.Physics
{
    /// <summary>
    /// Provides definitions and calculations for air density. 
    /// Sources:
    /// http://en.wikipedia.org/wiki/Air_density
    /// http://wahiduddin.net/calc/density_altitude.htm
    /// </summary>
    public class AirDensity
    {
        /// <summary>
        /// Nominal density of air at 0 degrees C in units of kg * m^-3
        /// </summary>
        public const double NominalAirDensity = 1.292; 
    }
}
