﻿//-----------------------------------------------------------------------------
// EnumConvert.cs
// (A. Schiffler, 2009)
//-----------------------------------------------------------------------------

namespace NewGamePhysics.Utilities
{
    using System;

    /// <summary>
    /// Generic converter for Enum types.
    /// </summary>
    public class EnumConvert
    {
        /// <summary>
        /// Change generic value to enum type T. 
        /// Or change enum value to generic type T.
        /// </summary>
        /// <typeparam name="T">The requested output type for the conversion.</typeparam>
        /// <param name="value">The generic or enum value to convert.</param>
        /// <returns>The converted value of type T.</returns>
        public static T ChangeTo<T>(object value)
        {
            Type type = typeof(T);
            if (!type.IsGenericType && type.IsEnum)
            {
                try
                {
                    if (value.GetType().IsValueType)
                    {
                        return (T)Enum.ToObject(type, value);
                    }
                    else
                    {
                        return (T)Enum.Parse(type, value.ToString());
                    }
                }
                catch
                {
                    return default(T);
                }
            }
            else 
            {
                try
                {
                    return (T)Convert.ChangeType(value, type);
                }
                catch
                {
                    return default(T);
                }
            }
        }
    }
}
