﻿#region File Description
//-----------------------------------------------------------------------------
// VectorFormatConverter.cs
//-----------------------------------------------------------------------------
#endregion

namespace NewGamePhysics.Utilities
{
    using System;
    using Microsoft.Xna.Framework;
    using NewGamePhysics.Mathematics;

    /// <summary>
    /// Utility functions which convert between VectorN (double) and 
    /// XNAs Vector2/Vector3(float) formats.
    /// </summary>
    public class VectorFormatConverter
    {
        /// <summary>
        /// Convert an array of 2-dimensional VectorN's to Vector2[].
        /// </summary>
        /// <param name="vectors">Input vectors.</param>
        /// <returns>Converted vectors.</returns>
        public static Vector2[] VectorNToVector2(VectorN[] vectors)
        {
            if (null == vectors)
            {
                throw new ArgumentNullException("vectors");
            }

            int size = vectors.Length;

            if (size == 0)
            {
                throw new ArgumentOutOfRangeException(
                    "vectors", 
                    "Input array must contain 1 or more elements");
            }

            Vector2[] result = new Vector2[size];
            for (int i = 0; i < size; i++)
            {
                if (vectors[i].N != 2)
                {
                    throw new ArgumentException(
                        "All input vectors must be 2 dimensional.",
                        "vectors");
                }

                result[i].X = Convert.ToSingle(vectors[i][0]);
                result[i].Y = Convert.ToSingle(vectors[i][1]);
            }

            return result;
        }

        /// <summary>
        /// Convert an array of 3-dimensional VectorN's to Vector3[].
        /// </summary>
        /// <param name="vectors">Input vectors.</param>
        /// <returns>Converted vectors.</returns>
        public static Vector3[] VectorNToVector3(VectorN[] vectors)
        {
            if (null == vectors)
            {
                throw new ArgumentNullException("vectors");
            }

            int size = vectors.Length;

            if (size == 0)
            {
                throw new ArgumentOutOfRangeException(
                    "vectors",
                    "Input array must contain 1 or more elements");
            }

            Vector3[] result = new Vector3[size];
            for (int i = 0; i < size; i++)
            {
                if (vectors[i].N != 3)
                {
                    throw new ArgumentException(
                        "All input vectors must be 3 dimensional.",
                        "vectors");
                }

                result[i].X = Convert.ToSingle(vectors[i][0]);
                result[i].Y = Convert.ToSingle(vectors[i][1]);
                result[i].Z = Convert.ToSingle(vectors[i][2]);
            }

            return result;
        }
    }
}
