﻿

namespace Tests
{
    using System;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NewGamePhysics.Utilities;

    /// <summary>
    /// Summary description for UnitTestAutorange
    /// </summary>
    [TestClass]
    public class UnitTestAutorange
    {
        public UnitTestAutorange()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod]
        public void GetSnapValueIsGreater()
        {
            double[] value = { 
              0.0,
              0.00131,
              0.12,
              0.2,
              0.49,
              0.51,
              0.75,
              10.75,
              31123,
              -0.00012,
              -0.12,
              -0.2,
              -0.49,
              -0.51,
              -0.75,
              -1.0,
              -10.75,
            };

            double[] expected = {
              0.0,
              0.002,
              0.2,
              0.2,
              0.5,
              1.0,
              1.0,
              20.0,
              50000,
              -0.0001,
              -0.1,
              -0.2,
              -0.2,
              -0.5,
              -0.5,
              -1.0,
              -10.0
            };

            for (int i = 0; i < value.Length; i++)
            {
                double snapValue = Autorange.GetSnapValue(value[i], true);
                Console.WriteLine(
                    "Autorange.GetSnapValue({0}, true): expected {1} got {2}",
                    value[i],
                    expected[i],
                    snapValue);
                Assert.AreEqual(expected[i], snapValue);
            }
        }

        [TestMethod]
        public void GetSnapValueIsLess()
        {
            double[] value = { 
              0.0,
              0.00131,
              0.12,
              0.2,
              0.49,
              0.51,
              0.75,
              10.75,
              31123,
              -0.00012,
              -0.12,
              -0.2,
              -0.49,
              -0.51,
              -0.75,
              -1.0,
              -10.75,
            };

            double[] expected = {
              0.0,
              0.001,
              0.1,
              0.1,
              0.2,
              0.5,
              0.5,
              10.0,
              20000,
              -0.0002,
              -0.2,
              -0.5,
              -0.5,
              -1.0,
              -1.0,
              -2.0,
              -20.0
            };

            for (int i = 0; i < value.Length; i++)
            {
                double snapValue = Autorange.GetSnapValue(value[i], false);
                Console.WriteLine(
                    "Autorange.GetSnapValue({0}, false): expected {1} got {2}",
                    value[i],
                    expected[i],
                    snapValue);
                Assert.AreEqual(expected[i], snapValue);
            }
        }
    }
}
