﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using NewGamePhysics.Physics;
using NewGamePhysics.Mathematics;

namespace Tests
{
    /// <summary>
    /// Summary description for UnitTestButterworthFilter
    /// </summary>
    [TestClass]
    public class UnitTestButterworthFilter
    {
        public UnitTestButterworthFilter()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod]
        public void HighPassSineSweep()
        {
            int num = 256;
            ButterworthFilter filter = 
                new ButterworthFilter(ButterworthFilterType.HighPass, 100, 20);

            double[] samples = new double[num];
            double a = 0.0;
            double s = Math.PI / 20;
            for (int i = 0; i < num; i++)
            {
                samples[i] = Math.Sin(a);
                a = a + s;
                s = s * 1.01;
            }

            double[] filteredSamples = filter.Calculate(samples);
            for (int i = 0; i < num; i++)
            {
                System.Console.WriteLine("{0} {1} {2}", i, samples[i], filteredSamples[i]);
            }
        }

        [TestMethod]
        public void HighPassSteps()
        {
            int num = 320;
            ButterworthFilter filter = 
                new ButterworthFilter(ButterworthFilterType.HighPass, 100, 10);

            double[] samples = new double[num];
            double v = 0.0;
            double vWant = 0.0;
            Random rand = new Random();
            for (int i = 0; i < num; i++)
            {
                if ((i % 32) == 0)
                {
                    vWant = rand.NextDouble();
                }

                v = 0.10 * v + 0.9 * vWant + 0.05*rand.NextDouble();

                samples[i] = v;
            }

            double[] filteredSamples = filter.Calculate(samples);
            for (int i = 0; i < num; i++)
            {
                System.Console.WriteLine("{0} {1} {2}", i, samples[i], filteredSamples[i]);
            }
        }

        [TestMethod]
        public void LowPassSineSweep()
        {
            int num = 256;
            ButterworthFilter filter =
                new ButterworthFilter(ButterworthFilterType.LowPass, 100, 20);

            double[] samples = new double[num];
            double a = 0.0;
            double s = Math.PI / 20;
            for (int i = 0; i < num; i++)
            {
                samples[i] = Math.Sin(a);
                a = a + s;
                s = s * 1.01;
            }

            double[] filteredSamples = filter.Calculate(samples);
            for (int i = 0; i < num; i++)
            {
                System.Console.WriteLine("{0} {1} {2}", i, samples[i], filteredSamples[i]);
            }
        }

        [TestMethod]
        public void LowPassSteps()
        {
            int num = 320;
            ButterworthFilter filter =
                new ButterworthFilter(ButterworthFilterType.LowPass, 100, 10);

            double[] samples = new double[num];
            double v = 0.0;
            double vWant = 0.0;
            Random rand = new Random();
            for (int i = 0; i < num; i++)
            {
                if ((i % 32) == 0)
                {
                    vWant = rand.NextDouble();
                }

                v = 0.10 * v + 0.9 * vWant + 0.05 * rand.NextDouble();

                samples[i] = v;
            }

            double[] filteredSamples = filter.Calculate(samples);
            for (int i = 0; i < num; i++)
            {
                System.Console.WriteLine("{0} {1} {2}", i, samples[i], filteredSamples[i]);
            }
        }       
    }
}
