﻿namespace Tests
{
    using System;
    using System.Text;
    using System.Threading;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NewGamePhysics.Utilities;
    using Microsoft.DirectX.DirectSound;

    /// <summary>
    /// Summary description for UnitTestHighResolutionTimer
    /// </summary>
    [TestClass]
    public class UnitTestDirectXAudio
    {
        public UnitTestDirectXAudio()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        [TestMethod]
        public void NullPlayback()
        {
            DirectXAudio player = new DirectXAudio((Device)null, 44100, (short)16, (short)2);
            player.Play(new PullAudioCallback(NullFiller));
            System.Threading.Thread.Sleep(1000);
            player.Stop();
        }

        [TestMethod]
        public void RandomPlayback()
        {
            DirectXAudio player = new DirectXAudio((Device)null, 44100, (short)16, (short)2);
            player.Play(new PullAudioCallback(RandomFiller));
            System.Threading.Thread.Sleep(1000);
            player.Stop();
        }

        #region sample_filler_callbacks

        private void NullFiller(IntPtr dest, int size)
		{
            int samples = size / 2;

            short[] buffer = new short[samples];

            for (int i = 0; i < samples; i++)
            {
                buffer[i] = 0;
            }

            System.Runtime.InteropServices.Marshal.Copy(buffer, 0, dest, samples);
        }

        private void RandomFiller(IntPtr dest, int size)
        {
            Random rand = new Random();
            int samples = size / 2;
            short[] buffer = new short[samples];
            for (int i = 0; i < samples; i++)
            {
                buffer[i] = Convert.ToInt16(rand.Next(short.MinValue, short.MaxValue));
            }

            System.Runtime.InteropServices.Marshal.Copy(buffer, 0, dest, samples);
        }

        #endregion
    }
}
