﻿

namespace Tests
{
    using System;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Microsoft.Xna.Framework;
    using Microsoft.Xna.Framework.Graphics;
    using NewGamePhysics.Mathematics;
    using NewGamePhysics.Physics;
    using NewGamePhysics.PhysicalElements;

    /// <summary>
    /// Summary description for UnitTestDoubleRegularPendulum
    /// </summary>
    [TestClass]
    public class UnitTestDoubleRegularPendulum
    {
        public UnitTestDoubleRegularPendulum()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        [TestMethod]
        public void UnitPendulumAtRest()
        {
            Vector2 origin = new Vector2();

            // New Pendulum
            DoubleRegularPendulumSimulation pendulum =
                new DoubleRegularPendulumSimulation(
                    origin,
                    1.0, 1.0, 1.0, 1.0,
                    9.81,
                    RotationalFrictionType.None);
            pendulum.SetInitialConditionsAtRest();

            AnimatePendulumSimulation(pendulum);
        }

        [TestMethod]
        public void UnitPendulumInMotionFrictionNone()
        {
            Vector2 origin = new Vector2();

            // New Pendulum
            DoubleRegularPendulumSimulation pendulum =
                new DoubleRegularPendulumSimulation(
                    origin,
                    1.0, 1.0, 1.0, 1.0,
                    9.81,
                    RotationalFrictionType.None);
            pendulum.SetInitialConditions(
                    (double)Math.PI * 0.8, (double)0, (double)0, (double)0);

            AnimatePendulumSimulation(pendulum);
        }

        [TestMethod]
        public void UnitPendulumInMotionFrictionLinear()
        {
            Vector2 origin = new Vector2();

            // New Pendulum
            DoubleRegularPendulumSimulation pendulum =
                new DoubleRegularPendulumSimulation(
                    origin,
                    1.0, 1.0, 1.0, 1.0,
                    9.81,
                    RotationalFrictionType.Linear);
            pendulum.SetInitialConditions(
                    (double)Math.PI * 0.8, (double)0, (double)0, (double)0);

            AnimatePendulumSimulation(pendulum);
        }

        [TestMethod]
        public void UnitPendulumInMotionFrictionStribeck()
        {
            Vector2 origin = new Vector2();

            // New Pendulum
            DoubleRegularPendulumSimulation pendulum =
                new DoubleRegularPendulumSimulation(
                    origin,
                    1.0, 1.0, 1.0, 1.0,
                    9.81,
                    RotationalFrictionType.Stribeck);
            pendulum.SetInitialConditions(
                    (double)Math.PI * 0.8, (double)0, (double)0, (double)0);

            AnimatePendulumSimulation(pendulum);
        }

        [TestMethod]
        public void SmallPendulumInMotionFrictionNone()
        {
            Vector2 origin = new Vector2();

            // New Pendulum
            DoubleRegularPendulumSimulation pendulum =
                new DoubleRegularPendulumSimulation(
                    origin,
                    0.1, 1.0, 0.1, 1.0,
                    9.81,
                    RotationalFrictionType.None);
            pendulum.SetInitialConditions(
                    (double)Math.PI * 0.8, (double)0, (double)0, (double)0);

            AnimatePendulumSimulation(pendulum);
        }

        private void AnimatePendulumSimulation(DoubleRegularPendulumSimulation pendulum)
        {
            int count = 0;
            for (int i = 0; i < 10; i++)
            {
                for (int j = 0; j < 1000; j++)
                {
                    pendulum.Animate();
                    count++;
                }

                double[] angles = pendulum.GetAngle();
                double[] velocities = pendulum.GetVelocity();
                double energy = pendulum.GetEnergy();

                Console.WriteLine("Iteration {5}: angles = {0} {1}  velocities = {2} {3}  energy = {4}",
                    angles[0], angles[1],
                    velocities[0], velocities[1],
                    energy,
                    count);
            }
        }
    }
}