﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using NewGamePhysics.Physics;

namespace Tests
{
    /// <summary>
    /// Summary description for UnitTestFrictionModel
    /// </summary>
    [TestClass]
    public class UnitTestFrictionModel
    {
        public UnitTestFrictionModel()
        {
            //
            // TODO: Add constructor logic here
            //
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod]
        public void TestFrictionTypeStribeck()
        {
            RotationalFrictionModel model = new RotationalFrictionModel(RotationalFrictionType.Stribeck);
            int steps = 100;
            double omegaMin = -1.0;
            double omegaMax =  1.0;
            double omegaStep = (omegaMax - omegaMin) / steps;
            for (int i = 0; i <= steps; i++)
            {
                double omega = omegaMin + omegaStep * i;
                double deltaOmega = model.ApplyFriction(omega) - omega;
                System.Console.WriteLine("{0} {1}", omega, deltaOmega);
                omega += omegaStep;
            }
        }
    }
}
