﻿namespace Tests
{
    using System;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NewGamePhysics.Mathematics;

    /// <summary>
    /// Summary description for UnitTestGamma
    /// </summary>
    [TestClass]
    public class UnitTestGamma
    {
        public UnitTestGamma()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        [TestMethod]
        public void GammaLogFunction()
        {
            const int numTestdata = 20;

            double[] x = { 
              0.20E+00,  
              0.40E+00,  
              0.60E+00,  
              0.80E+00,  
              1.00E+00,  
              1.10E+00,  
              1.20E+00,  
              1.30E+00,  
              1.40E+00,  
              1.50E+00,  
              1.60E+00,  
              1.70E+00,  
              1.80E+00,  
              1.90E+00,  
              2.00E+00,  
              3.00E+00,  
              4.00E+00,  
             10.00E+00,  
             20.00E+00,  
             30.00E+00 };

            // Test data source: Mathematica 
            double[] expected = { 
              0.1524063822430784E+01,  
              0.7966778177017837E+00,  
              0.3982338580692348E+00,  
              0.1520596783998375E+00,  
              0.0000000000000000E+00,  
             -0.4987244125983972E-01,  
             -0.8537409000331584E-01,  
             -0.1081748095078604E+00,  
             -0.1196129141723712E+00,  
             -0.1207822376352452E+00,  
             -0.1125917656967557E+00,  
             -0.9580769740706586E-01,  
             -0.7108387291437216E-01,  
             -0.3898427592308333E-01,  
             0.00000000000000000E+00,  
             0.69314718055994530E+00,  
             0.17917594692280550E+01,  
             0.12801827480081469E+02,  
             0.39339884187199494E+02,  
             0.71257038967168009E+02};

            double error;
            double value;
            for (int i = 0; i < numTestdata; i++)
            {
                value = Gamma.LogFunction(x[i]);
                error = Math.Abs(value - expected[i]);
                Console.WriteLine(
                    "Gamma.LogFunction({0}): expected {1} got {2} error {3}", 
                    x[i], 
                    expected[i], 
                    value, 
                    error); 
                Assert.IsTrue(error <= 1e-10);
            }
        }
    }
}
