﻿namespace Tests
{
    using System;
    using System.Text;
    using System.Threading;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NewGamePhysics.Utilities;

    /// <summary>
    /// Summary description for UnitTestHighResolutionTimer
    /// </summary>
    [TestClass]
    public class UnitTestHighResolutionTimer
    {
        public UnitTestHighResolutionTimer()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        [TestMethod]
        public void GetCounter()
        {
            long value1 = HighResolutionTimer.Counter();
            System.Console.WriteLine("Counter = " + value1);
            System.Threading.Thread.Sleep(1);
            long value2 = HighResolutionTimer.Counter();
            System.Console.WriteLine("Counter = " + value2 + " (again)");
            Assert.AreNotEqual(value1, value2, "Counter should be changing");
            System.Console.WriteLine("Difference: " + (value2 - value1));
        }

        [TestMethod]
        public void GetFrequency()
        {
            long value1 = HighResolutionTimer.Frequency();
            System.Console.WriteLine("Frequency = " + value1);
            System.Threading.Thread.Sleep(1);
            long value2 = HighResolutionTimer.Frequency();
            System.Console.WriteLine("Frequency = " + value2 + " (again)");
            Assert.AreEqual(value1, value2, "Frequency should not change");
        }

        [TestMethod]
        public void GetSeconds()
        {
            double value1 = HighResolutionTimer.Seconds();
            System.Console.WriteLine("Seconds = " + value1);
            System.Threading.Thread.Sleep(1);
            double value2 = HighResolutionTimer.Seconds();
            System.Console.WriteLine("Seconds = " + value2 + " (again)");
            Assert.AreNotEqual(value1, value2, "Seconds should be changing");
            System.Console.WriteLine("Difference: " + (value2 - value1));
        }
    }
}
