﻿namespace Tests
{
    using System;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NewGamePhysics.Utilities;

    /// <summary>
    /// Summary description for UnitTestScanf
    /// </summary>
    [TestClass]
    public class UnitTestScanf
    {        
        private TestContext testContextInstance;

        public UnitTestScanf()
        {
        }

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        
        [TestMethod]
        public void ScanfNullResult()
        {
            object[] result;
            result = ScanWrapper("1", "");
            Assert.IsTrue(result == null || result.Length ==  0);
            result = ScanWrapper("1", " ");
            Assert.IsTrue(result == null || result.Length == 0);
            result = ScanWrapper("1", "i");
            Assert.IsTrue(result == null || result.Length == 0);
            result = ScanWrapper("1", "%");
            Assert.IsTrue(result == null || result.Length == 0);
            result = ScanWrapper("1", "%%");
            Assert.IsTrue(result == null || result.Length == 0);
        }

        [TestMethod]
        public void ScanfSkip()
        {
            object[] result;
            result = ScanWrapper("1 2", "%*i %i");
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Length);
            Assert.AreEqual(null, result[0]);
            Assert.AreEqual(2, (int)result[1]);
            result = ScanWrapper("1 2", "%i %*i");
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Length);
            Assert.AreEqual(1, (int)result[0]);
            Assert.AreEqual(null, result[1]);
            result = ScanWrapper("1 2", "%*i %*i");
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Length);
            Assert.AreEqual(null, result[0]);
            Assert.AreEqual(null, result[1]);
        }

        [TestMethod]
        public void Scanfd()
        {
            object[] result;
            result = ScanWrapper("0", "%d");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0, (int)result[0]);
            result = ScanWrapper("1", "%d");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1, (int)result[0]);
            result = ScanWrapper("-1", "%d");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-1, (int)result[0]);
            result = ScanWrapper("123", "%d");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(123, (int)result[0]);
        }

        [TestMethod]
        public void Scanfi()
        {
            object[] result;
            result = ScanWrapper("0", "%i");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0, (int)result[0]);
            result = ScanWrapper("1", "%i");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1, (int)result[0]);
            result = ScanWrapper("-1", "%i");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-1, (int)result[0]);
            result = ScanWrapper("123", "%i");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(123, (int)result[0]);
        }

        [TestMethod]
        public void Scanfli()
        {
            object[] result;
            result = ScanWrapper("0", "%li");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0, (long)result[0]);
            result = ScanWrapper("1", "%li");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1, (long)result[0]);
            result = ScanWrapper("-1", "%li");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-1, (long)result[0]);
            result = ScanWrapper("123", "%li");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(123, (long)result[0]);
        }

        [TestMethod]
        public void Scanfhi()
        {
            object[] result;
            result = ScanWrapper("0", "%hi");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0, (short)result[0]);
            result = ScanWrapper("1", "%hi");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1, (short)result[0]);
            result = ScanWrapper("-1", "%hi");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-1, (short)result[0]);
            result = ScanWrapper("123", "%hi");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(123, (short)result[0]);
        }

        [TestMethod]
        public void Scanfo()
        {
            object[] result;
            result = ScanWrapper("0", "%o");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)0, (uint)result[0]);
            result = ScanWrapper("1", "%o");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)1, (uint)result[0]);
            result = ScanWrapper("10", "%o");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)8, (uint)result[0]);
        }

        [TestMethod]
        public void Scanfu()
        {
            object[] result;
            result = ScanWrapper("1", "%u");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)1, (uint)result[0]);
            result = ScanWrapper("0", "%u");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)0, (uint)result[0]);
            result = ScanWrapper("-1", "%u");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(null, result[0]);
            result = ScanWrapper("123", "%u");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)123, (uint)result[0]);
        }

        [TestMethod]
        public void Scanflu()
        {
            object[] result;
            result = ScanWrapper("1", "%lu");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((ulong)1, (ulong)result[0]);
            result = ScanWrapper("0", "%lu");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((ulong)0, (ulong)result[0]);
            result = ScanWrapper("-1", "%lu");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(null, result[0]);
            result = ScanWrapper("123", "%lu");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((ulong)123, (ulong)result[0]);
        }

        [TestMethod]
        public void Scanfhu()
        {
            object[] result;
            result = ScanWrapper("1", "%hu");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1, (ushort)result[0]);
            result = ScanWrapper("0", "%hu");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0, (ushort)result[0]);
            result = ScanWrapper("-1", "%hu");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(null, result[0]);
            result = ScanWrapper("123", "%hu");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(123, (ushort)result[0]);
        }

        [TestMethod]
        public void Scanfx()
        {
            object[] result;
            result = ScanWrapper("0", "%x");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)0, (uint)result[0]);
            result = ScanWrapper("1", "%x");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)1, (uint)result[0]);
            result = ScanWrapper("f", "%x");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)15, (uint)result[0]);
            result = ScanWrapper("10", "%x");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual((uint)16, (uint)result[0]);
        }

        [TestMethod]
        public void Scanff()
        {
            object[] result;
            result = ScanWrapper("0", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0.0f, (float)result[0]);
            result = ScanWrapper("1", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1.0f, (float)result[0]);
            result = ScanWrapper("1.0", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1.0f, (float)result[0]);
            result = ScanWrapper("-1", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-1.0f, (float)result[0]);
            result = ScanWrapper("-1.0", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-1.0f, (float)result[0]);
            result = ScanWrapper("1e2", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(100.0f, (float)result[0]);
            result = ScanWrapper("1e-2", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0.01f, (float)result[0]);
            result = ScanWrapper("-1.0e2", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-100.0f, (float)result[0]);
            result = ScanWrapper("-1.0e-2", "%f");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-0.01f, (float)result[0]);
        }

        [TestMethod]
        public void Scanflf()
        {
            object[] result;
            result = ScanWrapper("0", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0.0, (double)result[0]);
            result = ScanWrapper("1", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1.0, (double)result[0]);
            result = ScanWrapper("1.0", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(1.0, (double)result[0]);
            result = ScanWrapper("-1", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-1.0, (double)result[0]);
            result = ScanWrapper("-1.0", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-1.0, (double)result[0]);
            result = ScanWrapper("1e2", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(100.0, (double)result[0]);
            result = ScanWrapper("1e-2", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(0.01, (double)result[0]);
            result = ScanWrapper("-1.0e2", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-100.0, (double)result[0]);
            result = ScanWrapper("-1.0e-2", "%lf");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual(-0.01, (double)result[0]);
        }

        [TestMethod]
        public void Scanfs()
        {
            object[] result;
            result = ScanWrapper("Hello", "%s");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual("Hello", (string)result[0]);
            result = ScanWrapper("Hello World", "%s");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual("Hello", (string)result[0]);
            result = ScanWrapper("Hello World", "%s %s");
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Length);
            Assert.AreEqual("Hello", (string)result[0]);
            Assert.AreEqual("World", (string)result[1]);
        }

        [TestMethod]
        public void Scanfc()
        {
            object[] result;
            result = ScanWrapper("Hello World", "%c");
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Length);
            Assert.AreEqual('H', (char)result[0]);
            result = ScanWrapper("Hello World", "%c%c");
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Length);
            Assert.AreEqual('H', (char)result[0]);
            Assert.AreEqual('e', (char)result[1]);
            result = ScanWrapper("Hello World", "%ce%c");
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Length);
            Assert.AreEqual('H', (char)result[0]);
            Assert.AreEqual('l', (char)result[1]);
        }

        /// <summary>
        /// Private wrapper for scanf.Scan() that
        /// logs input and output.
        /// </summary>
        /// <param name="text">Test to scan</param>
        /// <param name="format">Format to use</param>
        /// <returns>Scanf result</returns>
        private object[] ScanWrapper(string text, string format)
        {
            Scanf scanf = new Scanf();
            object[] results;
            System.Console.WriteLine("scanf.Scan('{0}','{1}')", text, format);
            results = scanf.Scan(text, format);
            if (null == results)
            {
                System.Console.WriteLine("null");
            }
            else
            {
                int i = 0;
                foreach (object result in results)
                {
                    i++;
                    if (null == result)
                    {
                        System.Console.WriteLine("{0}: null", i);
                    }
                    else
                    {
                        System.Console.WriteLine("{0}: type={1} value={2}", i, result.GetType(), result.ToString());
                    }
                }
            }

            return results;
        }
    }
}
