//-----------------------------------------------------------------------------
// GravityChooser.cs
// (A. Schiffler, 2009-2011)
//-----------------------------------------------------------------------------
namespace GravityChooser
{
    using Microsoft.Xna.Framework;
    using Microsoft.Xna.Framework.Graphics;
    using Microsoft.Xna.Framework.Input;

    using NewGamePhysics.StateManager;
    using NewGamePhysics.Utilities;

    /// <summary>
    /// This is the main type of the game
    /// </summary>
    public class GravityChooser : Microsoft.Xna.Framework.Game
    {
        /// <summary>
        /// The current game state.
        /// </summary>
        public static GravityChooserState state = new GravityChooserState();

        // Graphics
        private GraphicsDeviceManager graphics;
        private ScreenManager screenManager;
        private Viewport viewport;
        private Matrix projectionMatrix;

        // Inputs
        private Gamepads gamepads;

        /// <summary>
        /// Constructor of game.
        /// </summary>
        /// <param name="fullscreen">Enable fullscreen mode if flag is set.</param>
        public GravityChooser(bool fullscreen)
        {
            // New input object
            gamepads = new Gamepads();

            // Content root
            Content.RootDirectory = "Content";

            // Prefer a resolution suitable for both Windows and XBox 360
            graphics = new GraphicsDeviceManager(this);
            graphics.PreferredBackBufferWidth = 853;
            graphics.PreferredBackBufferHeight = 480;

            // Maybe set to fullscreen
            graphics.IsFullScreen = fullscreen;

            // Enable antialiasing
            graphics.PreferMultiSampling = true;

            // Create the screen manager component.
            screenManager = new ScreenManager(this);
            Components.Add(screenManager);
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // Current viewport
            viewport = graphics.GraphicsDevice.Viewport;

            // Enable mouse
            this.IsMouseVisible = true;

            // Aspect ratio
            float aspectRatio = graphics.GraphicsDevice.Viewport.Width /
                (float)graphics.GraphicsDevice.Viewport.Height;

            // Create the projection matrix.
            projectionMatrix = Matrix.CreatePerspectiveFieldOfView(
                MathHelper.ToRadians(45.0f), aspectRatio, 1f, 10000);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Load textures

            // Load fonts
            screenManager.AddFont("retro", "Fonts/retroMedium");
            screenManager.AddFont("courier", "Fonts/courier");

            // Activate the first screens.
            screenManager.AddScreen(new GravityChooserBackgroundScreen(), null);
            screenManager.AddScreen(new GravityChooserMainMenuScreen(), null);
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Keyboard state
            KeyboardState keyState = Keyboard.GetState();
            Keys[] keys = keyState.GetPressedKeys();

            // Allows the game to exit
            if (keyState.IsKeyDown(Keys.Delete))
            {
                this.Exit();
            }

            // Check gamepad
            if ((gamepads != null) && (gamepads.Items.Count > 0))
            {
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            // Clear to black
            graphics.GraphicsDevice.Clear(Color.Black);

            // Redraw
            base.Draw(gameTime);
        }
    }
}
