﻿//-----------------------------------------------------------------------------
// GravityChooserState.cs
// (A. Schiffler, 2009-2011)
//-----------------------------------------------------------------------------

namespace GravityChooser
{
    using System;
    using NewGamePhysics.Physics;

    /// <summary>
    /// The global state of the gravity chooser game
    /// manipulated by the player.
    /// </summary>
    public class GravityChooserState
    {
        /// <summary>
        ///  Celestial object we are modelling/displaying.
        /// </summary>
        private CelestialObject currentCelestialObject = CelestialObject.Earth;

        /// <summary>
        /// The earths gravity model we are using.
        /// </summary>
        private EarthGravityModel currentEarthGravityModel = EarthGravityModel.GfcGrid;

        /// <summary>
        /// The current texture variation to use for a planet.
        /// </summary>
        int currentTextureVariation = 0;

        /// <summary>
        /// The currently selected gravity value.
        /// </summary>
        private double currentGravity = 0.0;

        /// <summary>
        ///  Gets or sets the celestial object we are modelling.
        /// </summary>
        public CelestialObject CurrentCelestialObject
        {
            get { return this.currentCelestialObject; }
            set { this.currentCelestialObject = value; }
        }

        /// <summary>
        /// Gets or sets the earths gravity model we are using.
        /// </summary>
        public EarthGravityModel CurrentEarthGravityModel
        {
            get { return this.currentEarthGravityModel; }
            set { this.currentEarthGravityModel = value; }
        }

        /// <summary>
        /// Gets or sets the texture variation to use .
        /// </summary>
        public int CurrentTextureVariation
        {
            get { return this.currentTextureVariation; }
            set { this.currentTextureVariation = value; }
        }

        /// <summary>
        /// Gets or sets the current selected gravity value.
        /// </summary>
        public double CurrentGravity
        {
            get { return currentGravity; }
            set { currentGravity = value; }
        }
    }
}
