﻿//-----------------------------------------------------------------------------
// MontyHallGameState.cs
// (C) A. Schiffler, 2009-2011
//-----------------------------------------------------------------------------

namespace MontyHallGame
{
    using System;
    using NewGamePhysics.Physics;
    using NewGamePhysics.Utilities;
    using NewGamePhysics.Networking;
    using NewGamePhysics.PhysicalElements;

    /// <summary>
    /// The global state of the monty hall game
    /// manipulated by the player.
    /// </summary>
    public class MontyHallGameState
    {
        #region private_fields

        /// <summary>
        /// Total number of losses.
        /// </summary>
        private int losses;

        /// <summary>
        /// Total number of wins.
        /// </summary>
        private int wins;

        /// <summary>
        /// Total number of door switches.
        /// </summary>
        private int switches;

        #endregion

        #region public_fields

        /// <summary>
        /// Global random number source playtrulyrandom.com for the game.
        /// </summary>
        PhysicalRandomNumberGenerator rng = new PhysicalRandomNumberGenerator(EntropySourceType.PlayTrulyRandom, "MontyHallGame_v1");

        /// <summary>
        /// The accumulated time the player is in the active
        /// gameplay state.
        /// </summary>
        public double playTime;

        #endregion

        #region public_properties

        /// <summary>
        /// Gets the current random number generator instance.
        /// </summary>
        public PhysicalRandomNumberGenerator Rng
        {
            get { return this.rng; }
        }

        /// <summary>
        /// Gets or sets the total number of losses.
        /// </summary>
        public int Losses
        {
            get { return this.losses; }
            set { this.losses = value; }
        }

        /// <summary>
        /// Gets or sets the total number of wins.
        /// </summary>
        public int Wins
        {
            get { return this.wins; }
            set { this.wins = value; }
        }

        /// <summary>
        /// Gets or sets the total number of door switches.
        /// </summary>
        public int Switches
        {
            get { return this.switches; }
            set { this.switches = value; }
        }

        #endregion
    }
}
