// Apply chromakey on blue component with linear transition

sampler TextureSampler : register(s0);

float4 PixelShader(float2 texCoord: TEXCOORD0) : COLOR0
{
	float3 color = tex2D(TextureSampler, texCoord);
	float alpha = 1.0f;
	if (color.b > color.r)
	{
		if (color.b > color.g)
		{
			alpha = 2.0f * color.b - color.r + color.g;
			if (alpha < 0.5f)
			{
				alpha = 1.0f;
			}
			else
			{
				if (alpha > 1.5f)
				{
					alpha = 0.0f;
				}
				else 
				{
					alpha = 1.0f - 2.0f * (alpha - 0.5f);
				}
			}
		}
		else
		{
			alpha = 1.0f;
		}
	} 
	else
	{
		alpha = 1.0f;
	}
	 
	float4 newcolor = float4(color.r,  color.g, color.b, alpha);
	return newcolor;
}
technique
{
	pass P0
	{
		PixelShader = compile ps_2_0 PixelShader();
	}
}
