// Pixel shader which combines a source image and the base scene

sampler CombineSampler : register(s0);
sampler BaseSampler : register(s1);

float CombineIntensity;

float4 PixelShader(float2 texCoord : TEXCOORD0) : COLOR0
{
    // Look up the source (bloom) and base colors
    float4 source = tex2D(CombineSampler, texCoord);
    float4 base = tex2D(BaseSampler, texCoord);
    
    // Brighten source image
    source *= CombineIntensity;
    
    // Darken base image where source is bright
    base *= (1 - saturate(source));
    
    // Combine the pixels
    return base + source ;
}
technique
{
	pass P0
    {
        PixelShader = compile ps_2_0 PixelShader();
    }
}
