uniform extern texture ScreenTexture;

sampler ScreenS = sampler_state
{
     Texture = <ScreenTexture>;
};

float4 PixelShader(float2 texCoord: TEXCOORD0) : COLOR
{
	float3 color = tex2D(ScreenS, texCoord);
	float grey = dot(color, float3(0.212671f, 0.715160f, 0.072169f));
	grey = clamp(grey, 0, 1);
	float4 newcolor = float4(grey, grey, grey, 1.0f);
	return newcolor;
}
technique
{
	pass P0
	{
		PixelShader = compile ps_2_0 PixelShader();
	}
}