// Pixel shader applies a one dimensional 15-tap filter

sampler TextureSampler : register(s0);

#define SAMPLE_COUNT 15

float2 TapOffsets[SAMPLE_COUNT];
float TapWeights[SAMPLE_COUNT];

float4 PixelShader(float2 texCoord : TEXCOORD0) : COLOR0
{
    float4 c = 0;
    
    // Combine weighted image filter taps
    for (int i = 0; i < SAMPLE_COUNT; i++)
    {
        c += tex2D(TextureSampler, texCoord + TapOffsets[i]) * TapWeights[i];
    }
    
    return c;
}
technique
{
	pass P0
    {
        PixelShader = compile ps_2_0 PixelShader();
    }
}