//-----------------------------------------------------------------------------
// ISecondDerivative.cs
// (A. Schiffler, 2009)
//-----------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

namespace NewGamePhysics.Mathematics
{
    /// <summary>
    /// Defines the interface giving the vector of second derivatives
    /// Based on code from Vit Buchta, June 2007
    /// </summary>
    public interface ISecondDerivative
    {
        /// <summary>
        /// The method calculating the second derivatives of a function.
        /// </summary>
        /// <param name="t">Current time.</param>
        /// <param name="y">VectorN of positions.</param>
        /// <param name="dy">VectorN of velocities.</param>
        /// <returns>A vector representing the second derivative.</returns>
        VectorN GetValue(double t, VectorN y, VectorN dy);
    }
}
