﻿//-----------------------------------------------------------------------------
// Volume.cs
// (A. Schiffler, 2009)
//-----------------------------------------------------------------------------

namespace NewGamePhysics.Mathematics
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// Calculations for volume formulas of various objects.
    /// </summary>
    public static class Volume
    {
        /// <summary>
        /// Volume of a cube.
        /// </summary>
        /// <param name="length">The length of any side.</param>
        /// <returns>The volume.</returns>
        public static double Cube(double length)
        {
            return length * length * length;
        }

        /// <summary>
        /// Volume of a sphere.
        /// </summary>
        /// <param name="radius">The radius of the sphere.</param>
        /// <returns>The volume.</returns>
        public static double Sphere(double radius)
        {
            return (4.0 / 3.0) * Math.PI * radius * radius * radius;
        }

        /// <summary>
        /// Volume of a cone.
        /// </summary>
        /// <param name="radius">The radius of the cone base.</param>
        /// <param name="height">The height of the cone.</param>
        /// <returns>The volume.</returns>
        public static double Cone(double radius, double height)
        {
            return (1.0 / 3.0) * Math.PI * radius * radius * height;
        }

        /// <summary>
        /// Volume of a cylinder.
        /// </summary>
        /// <param name="radius">The radius of the cylinder base.</param>
        /// <param name="height">The height of the cylinder.</param>
        /// <returns>The volume.</returns>
        public static double Cylinder(double radius, double height)
        {
            return Math.PI * radius * radius * height;
        }

        /// <summary>
        /// Volume of a general prism
        /// </summary>
        /// <param name="area">The area of the prism base.</param>
        /// <param name="height">The height of the prism.</param>
        /// <returns>The volume.</returns>
        public static double Prism(double area, double height)
        {
            return area * height;
        }

        /// <summary>
        /// Volume of a pyramid
        /// </summary>
        /// <param name="area">The area of the pyramid base.</param>
        /// <param name="height">The height of the pyramid.</param>
        /// <returns>The volume.</returns>
        public static double Pyramid(double area, double height)
        {
            return (1.0 / 3.0) * area * height;
        }
    }
}
