﻿//-----------------------------------------------------------------------------
// InfoLinkBase.cs
// (A. Schiffler, 2009)
//-----------------------------------------------------------------------------

namespace NewGamePhysics.Networking
{
    using System;
    using System.Net;
    using System.Net.Sockets;

    /// <summary>
    /// Base class for an InfoLink UDP connection.
    /// </summary>
    public class InfoLinkNetBase
    {
        /// <summary>
        /// The defaulty UDP port to use.
        /// </summary>
        public const int InfoLinkNetDefaultPort = 10321;

        /// <summary>
        /// The UDP client object.
        /// </summary>
        internal UdpClient udpClient;

        /// <summary>
        /// The IP broadcast endpoint.
        /// </summary>
        internal IPEndPoint endPoint;

        /// <summary>
        /// The connection port.
        /// </summary>
        internal int port = 0;

        /// <summary>
        /// The connected state.
        /// </summary>
        private bool connected = false;

        /// <summary>
        /// Gets the current port set for the connection.
        /// </summary>
        public int Port
        {
            get { return this.port; }
        }

        /// <summary>
        /// The current connected state of the connection.
        /// </summary>
        public bool Connected
        {
            get { return this.connected; }
            set { this.connected = value; }
        }
    }
}
