﻿//-----------------------------------------------------------------------------
// InfoLinkSerializer.cs
// (A. Schiffler, 2009)
//-----------------------------------------------------------------------------

namespace NewGamePhysics.Networking
{
    using System;
    using System.IO;
    using System.Text;
    using System.Xml;
    using System.Collections.Generic;
    using System.Xml.Serialization;

    /// <summary>
    /// Helper class to serialize/deserialize an InfoLink object.
    /// </summary>
    public class InfoLinkSerializer
    {
        /// <summary>
        /// Serializes an InfoLink object into XML.
        /// </summary>
        /// <param name="infoLink">The InfoLink object to serialize.</param>
        /// <returns>The XML representation of the InfoLink object.</returns>
        public static string Serialize(InfoLink infoLink)
        {
            string xmlText = string.Empty;
            XmlSerializer xmlSerializer = new XmlSerializer(typeof(InfoLink));
            StringBuilder xmlSb = new StringBuilder();
            TextWriter textWriter = new StringWriter(xmlSb);
            xmlSerializer.Serialize(textWriter, infoLink);
            xmlText = xmlSb.ToString();
            return xmlText;
        }

        /// <summary>
        /// Serializes an array of InfoLink objects into XML.
        /// </summary>
        /// <param name="infoLinks">The InfoLink array to serialize.</param>
        /// <returns>The XML representation of the InfoLink object.</returns>
        public static string SerializeArray(InfoLink[] infoLinks)
        {
            string xmlText = string.Empty;
            XmlSerializer xmlSerializer = new XmlSerializer(typeof(InfoLink[]));
            StringBuilder xmlSb = new StringBuilder();
            TextWriter textWriter = new StringWriter(xmlSb);
            xmlSerializer.Serialize(textWriter, infoLinks);
            xmlText = xmlSb.ToString();
            return xmlText;
        }

        /// <summary>
        /// Deserialize XML into an InfoLink object.
        /// </summary>
        /// <param name="xmlText">The XML to deserialize.</param>
        /// <returns>The InfoLink object.</returns>
        public static InfoLink Deserialize(string xmlText)
        {
            XmlSerializer xmlSerializer = new XmlSerializer(typeof(InfoLink));
            TextReader textReader = new StringReader(xmlText);
            InfoLink infoLink = (InfoLink)xmlSerializer.Deserialize(textReader);
            return infoLink;
        }

        /// <summary>
        /// Deserialize XML into an array of InfoLink objects.
        /// </summary>
        /// <param name="xmlText">The XML to deserialize.</param>
        /// <returns>The InfoLink array.</returns>
        public static InfoLink[] DeserializeArray(string xmlText)
        {
            XmlSerializer xmlSerializer = new XmlSerializer(typeof(InfoLink));
            TextReader textReader = new StringReader(xmlText);
            XmlTextReader xmlReader = new XmlTextReader(textReader);
            xmlReader.Normalization = true;
            List<InfoLink> infoLinks = new List<InfoLink>();
            while (!xmlReader.EOF && xmlReader.ReadToFollowing("InfoLink"))
            {
                InfoLink newInfoLink = (InfoLink)xmlSerializer.Deserialize(xmlReader);
                infoLinks.Add(newInfoLink);
            }

            return infoLinks.ToArray();
        }
    }
}

