﻿// --------------------------------------------------------
// DragCoefficient.cs
// (A. Schiffler, 2009)
// --------------------------------------------------------

namespace NewGamePhysics.Physics
{
    using System;

    /// <summary>
    /// Class describing various measured drag coefficients of
    /// objects for laminar (slow) flow.
    /// Source: wikipedia
    /// </summary>
    public class DragCoefficient
    {
        /// <summary>
        /// Drag coefficient of a sphere.
        /// </summary>
        public const double Sphere = 0.47;

        /// <summary>
        /// Drag coefficient of a semi-sphere,
        /// round part facing the flow.
        /// </summary>
        public const double HalfSphere = 0.42;

        /// <summary>
        /// Drag coefficient of a cone, top
        /// facing the flow.
        /// </summary>
        public const double Cone = 0.50;

        /// <summary>
        /// Drag coefficient of a cube, flat 
        /// side facing the flow.
        /// </summary>
        public const double Cube = 1.05;

        /// <summary>
        /// Drag coefficient of a cube, corner
        /// facing the flow.
        /// </summary>
        public const double AngledCube = 0.80;

        /// <summary>
        /// Drag coefficient of a streamlined
        /// body (teardrop shaped), thick side
        /// facing the flow.
        /// </summary>
        public const double StreamlinedBody = 0.04;
    }
}
