//-----------------------------------------------------------------------------
// PlayerIndexEventArgs.cs
// (Based on XNA Community Game Platform Demo, Microsoft Corp., 2008)
//-----------------------------------------------------------------------------

namespace NewGamePhysics.StateManager
{
    using System;
    using Microsoft.Xna.Framework;

    /// <summary>
    /// Custom event argument which includes the index of the player who
    /// triggered the event. Used by the MenuEntry.Selected event.
    /// </summary>
    public class PlayerIndexEventArgs : EventArgs
    {
        /// <summary>
        /// The player index.
        /// </summary>
        private PlayerIndex playerIndex;

        /// <summary>
        /// Constructor for teh PlayerIndexEventArgs object.
        /// </summary>
        /// <param name="playerIndex">The player index.</param>
        public PlayerIndexEventArgs(PlayerIndex playerIndex)
        {
            this.playerIndex = playerIndex;
        }

        /// <summary>
        /// Gets the index of the player who triggered this event.
        /// </summary>
        public PlayerIndex PlayerIndex
        {
            get { return playerIndex; }
        }
    }
}
