﻿//-----------------------------------------------------------------------------
// Autorange.cs
// (A. Schiffler, 2009)
//-----------------------------------------------------------------------------

namespace NewGamePhysics.Utilities
{
    using System;

    /// <summary>
    /// Class to assist in autoranging chart axes or value displays.
    /// </summary>
    public class Autorange
    {
        /// <summary>
        /// Calculates the closest member in the sequence
        /// (... 0.5, 1, 2, 5, 10, 20 ...) to any given value.
        /// </summary>
        /// <param name="valueToSnap">The value to check.</param>
        /// <param name="snapIsGreater">If true, the snap value is numerically
        /// greater than value; or less if false.</param>
        /// <returns>The snap value.</returns>
        public static double GetSnapValue(double valueToSnap, bool snapIsGreater)
        {
            // Value range factors for positive numbers in sequence.
            double[] factorsP = { 1.0, 2.0, 5.0, 10.0 };

            // Value range factors for negative numbers in sequence.
            double[] factorsN = { 10.0, 5.0, 2.0, 1.0 };

            // Determine factor for input
            double[] factors;
            if (valueToSnap != 0.0)
            {
                bool isPositive = (valueToSnap > 0.0);
                double exponent = Math.Floor(Math.Log10(Math.Abs(valueToSnap)));
                double valueBase = Math.Pow(10, exponent);

                if (isPositive)
                {
                    factors = factorsP;
                }
                else
                {
                    factors = factorsN;
                    valueBase = -valueBase;
                }

                factors[0] *= valueBase;
                for (int i = 1; i < 4; i++)
                {
                    factors[i] *= valueBase;
                    if (factors[i] >= valueToSnap)
                    {
                        if (snapIsGreater)
                        {
                            return factors[i];
                        }
                        else
                        {
                            return factors[i - 1];
                        }
                    }
                }
            }

            // Default
            return 0.0;
        }
    }
}
