﻿
namespace Tests
{
    using System;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NewGamePhysics.Mathematics;

    /// <summary>
    /// Summary description for UnitTestBicubic
    /// </summary>
    [TestClass]
    public class UnitTestBicubic
    {
        public UnitTestBicubic()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod]
        public void BicubicInterpolationZero()
        {
            double[,] G = {{0.0, 0.0, 0.0, 0.0},
                           {0.0, 0.0, 0.0, 0.0},
                           {0.0, 0.0, 0.0, 0.0},
                           {0.0, 0.0, 0.0, 0.0}};

            Bicubic bicubic = new Bicubic(G);
            double g;
            g = bicubic.Calc(0.0, 0.0);
            Assert.AreEqual(0.0, g);
            g = bicubic.Calc(1.0, 0.0);
            Assert.AreEqual(0.0, g);
            g = bicubic.Calc(0.0, 1.0);
            Assert.AreEqual(0.0, g);
            g = bicubic.Calc(1.0, 1.0);
            Assert.AreEqual(0.0, g);

            g = bicubic.Calc(0.5, 0.5);
            Assert.AreEqual(0.0, g);
        }

        [TestMethod]
        public void BicubicInterpolationOne()
        {
            double[,] G = {{1.0, 1.0, 1.0, 1.0},
                           {1.0, 1.0, 1.0, 1.0},
                           {1.0, 1.0, 1.0, 1.0},
                           {1.0, 1.0, 1.0, 1.0}};

            Bicubic bicubic = new Bicubic(G);
            double g;
            g = bicubic.Calc(0.0, 0.0);
            Assert.AreEqual(1.0, g);
            g = bicubic.Calc(1.0, 0.0);
            Assert.AreEqual(1.0, g);
            g = bicubic.Calc(0.0, 1.0);
            Assert.AreEqual(1.0, g);
            g = bicubic.Calc(1.0, 1.0);
            Assert.AreEqual(1.0, g);

            g = bicubic.Calc(0.5, 0.5);
            Assert.AreEqual(1.0, g);
        }

        [TestMethod]
        public void BicubicInterpolationBox()
        {
            double[,] G = {{1.0, 1.0, 1.0, 1.0},
                           {1.0, 0.0, 0.0, 1.0},
                           {1.0, 0.0, 0.0, 1.0},
                           {1.0, 1.0, 1.0, 1.0}};

            Bicubic bicubic = new Bicubic(G);
            double g;
            g = bicubic.Calc(0.5, 0.5);
            Assert.IsTrue(g <= 0.0);

            g = bicubic.Calc(0.0, 0.0);
            Assert.AreEqual(0.0, g);
            g = bicubic.Calc(1.0, 0.0);
            Assert.AreEqual(0.0, g);
            g = bicubic.Calc(0.0, 1.0);
            Assert.AreEqual(0.0, g);
            g = bicubic.Calc(1.0, 1.0);
            Assert.AreEqual(0.0, g);
        }
    }
}
