﻿namespace Tests
{
    using System;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NewGamePhysics.Mathematics;

    /// <summary>
    /// Summary description for UnitTestFactorial
    /// </summary>
    [TestClass]
    public class UnitTestFactorial
    {
        public UnitTestFactorial()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        [TestMethod]
        public void FactorialCalc()
        {
            uint[] x = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

            // Test data source: Mathematica 
            ulong[] expected = { 1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800 };

            ulong value;
            int numTestdata = expected.Length;
            for (int i = 0; i < numTestdata; i++)
            {
                value = Factorial.Calc(x[i]);
                Console.WriteLine(
                    "Factorial.Calc({0}): expected {1} got {2}",
                    x[i],
                    expected[i],
                    value);
                Assert.AreEqual(expected[i], value);
            }
        }

        [TestMethod]
        public void FactorialCalcDouble()
        {

            int[] x = { -1, 0, 1, 2, 3, 4, 5, 6, 7, 8 };

            // Test data source: Mathematica 
            ulong[] expected = { 1, 1, 1, 2, 3, 8, 15, 48, 105, 384 };

            ulong value;
            int numTestdata = expected.Length;
            for (int i = 0; i < numTestdata; i++)
            {
                value = Factorial.CalcDouble(x[i]);
                Console.WriteLine(
                    "Factorial.CalcDouble({0}): expected {1} got {2}",
                    x[i],
                    expected[i],
                    value);
                Assert.AreEqual(expected[i], value);
            }
        }
    }
}

