﻿namespace Tests
{
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Microsoft.Xna.Framework;
    using NewGamePhysics.Utilities;

    /// <summary>
    /// Unit tests for NewGamePhysics.Utilities.IntersectionTest class
    /// </summary>
    [TestClass]
    public class UnitTestIntersection
    {
        public UnitTestIntersection()
        {
            //
            // TODO: Add constructor logic here
            //
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod]
        public void TestCircleInCircle2D()
        {
            // positive tests
            float[,] Tp = {
                           {0.0f, 0.0f, 1.0f}, //// center+radius
                           {0.5f, 0.5f, 1.0f},

                           {0.0f, 0.0f, 1.0f}, 
                           {1.0f, 1.0f, 1.0f},

                           {0.0f, 0.0f, 1.0f}, 
                           {0.0f, 0.0f, 0.1f},

                           {0.0f, 0.0f, 1.0f}, 
                           {2.0f, 0.0f, 1.0f},

                           {0.0f, 0.0f, 1.0f}, 
                           {0.0f, 1.0f, 0.0f},

                           {0.0f, 0.0f, 1.0f}, 
                           {1.0f, 0.0f, 0.0f},

                           {0.0f, 0.0f, 1.0f}, 
                           {0.0f, 0.0f, 0.0f},

                           {0.0f, 0.0f, 0.0f}, 
                           {0.0f, 0.0f, 0.0f},
                          };

            // negative tests
            float[,] Tn = {
                           {0.0f, 0.0f, 1.0f}, //// center+radius
                           {2.0f, 2.0f, 1.0f},

                           {0.0f, 0.0f, 1.0f},
                           {2.0f, 2.0f, 0.0f},

                           {0.0f, 0.0f, -1.0f}, 
                           {1.0f, 1.0f, 1.0f},

                           {0.0f, 0.0f, 1.0f}, 
                           {1.0f, 1.0f, -1.0f},

                           {0.0f, 0.0f, -1.0f}, 
                           {1.0f, 1.0f, -1.0f},

                          };

            Vector2 center1;
            float radius1;
            Vector2 center2;
            float radius2;
            bool result;
            for (int i = 0; i < Tp.Length / 3; i += 2)
            {
                center1 = new Vector2(Tp[i + 0, 0], Tp[i + 0, 1]);
                radius1 = Tp[i + 0, 2];
                center2 = new Vector2(Tp[i + 1, 0], Tp[i + 1, 1]);
                radius2 = Tp[i + 1, 2];
                result = IntersectionTest.CircleInCircle2D(center1, radius1, center2, radius2);
                Assert.IsTrue(result);
                result = IntersectionTest.CircleInCircle2D(center2, radius2, center1, radius1);
                Assert.IsTrue(result);
            }

            for (int i = 0; i < Tn.Length / 3; i += 2)
            {
                center1 = new Vector2(Tn[i + 0, 0], Tn[i + 0, 1]);
                radius1 = Tn[i + 0, 2];
                center2 = new Vector2(Tn[i + 1, 0], Tn[i + 1, 1]);
                radius2 = Tn[i + 1, 2];
                result = IntersectionTest.CircleInCircle2D(center1, radius1, center2, radius2);
                Assert.IsFalse(result);
                result = IntersectionTest.CircleInCircle2D(center2, radius2, center1, radius1);
                Assert.IsFalse(result);
            }
        }

        [TestMethod]
        public void TestPointInPolygon2D()
        {
            // positive tests
            float[,] Tp = {
                           {0.0f, 0.0f}, //// triangle
                           {1.0f, 0.0f},
                           {0.0f, 1.0f},
                           {0.1f, 0.1f}, //// test point

                           {0.0f, 0.0f},
                           {1.0f, 0.0f},
                           {0.0f, 1.0f},
                           {0.0f, 0.0f},
                          };

            // negative tests
            float[,] Tn = {
                           {0.0f, 0.0f}, //// triangle
                           {1.0f, 0.0f},
                           {0.0f, 1.0f},
                           {-0.1f, -0.1f}, //// test point

                           {0.0f, 0.0f},
                           {1.0f, 0.0f},
                           {0.0f, 1.0f},
                           {1.0f, 1.0f},

                           {0.0f, 0.0f},
                           {1.0f, 0.0f},
                           {0.0f, 1.0f},
                           {0.0f, 2.0f},
                          };

            Vector2[] polygon = new Vector2[3];
            Vector2 test;
            bool result;
            for (int i = 0; i < Tp.Length / 2; i += 4)
            {
                // order permutation
                for (int p = 0; p < 3; p++)
                {
                    for (int j = 0; j < 3; j++)
                    {
                        int x = (j + p) % 3;
                        polygon[j] = new Vector2(Tp[i + x, 0], Tp[i + x, 1]);
                    }

                    test = new Vector2(Tp[i + 3, 0], Tp[i + 3, 1]);
                    result = IntersectionTest.PointInPolygon2D(polygon, test);
                    Assert.IsTrue(result);
                }
            }

            for (int i = 0; i < Tn.Length / 2; i += 4)
            {
                // order permutation
                for (int p = 0; p < 3; p++)
                {
                    for (int j = 0; j < 3; j++)
                    {
                        int x = (j + p) % 3;
                        polygon[j] = new Vector2(Tn[i + x, 0], Tn[i + x, 1]);
                    }

                    test = new Vector2(Tn[i + 3, 0], Tn[i + 3, 1]);
                    result = IntersectionTest.PointInPolygon2D(polygon, test);
                    Assert.IsFalse(result);
                }
            }
        }

        [TestMethod]
        public void TestTriangleTriangleIntersect2D()
        {
            // positive tests
            float[,] Tp = {
                          {0.0f, 0.0f},
                          {1.0f, 0.0f},
                          {0.0f, 1.0f},
                          {0.0f, 0.0f},
                          {1.0f, 0.0f},
                          {0.0f, 1.0f},

                          {0.0f, 0.0f},
                          {1.0f, 0.0f},
                          {0.0f, 1.0f},
                          {0.1f, 0.1f},
                          {1.1f, 0.1f},
                          {0.1f, 1.1f},

                          {0.0f, 0.0f},
                          {1.0f, 0.0f},
                          {0.0f, 1.0f},
                          {0.0f, 0.0f},
                          {-1.0f, 0.0f},
                          {0.0f, -1.0f},                         

                          {-0.1f, 0.0f},
                          {0.1f, 0.0f},
                          {0.0f, 1.0f},
                          {-0.5f, 0.4f},
                          {-0.5f, 0.6f},
                          {0.5f, 0.5f},                         
                         };

            // negative tests
            float[,] Tn = {
                          {0.0f, 0.0f},
                          {1.0f, 0.0f},
                          {0.0f, 1.0f},
                          {1.0f, 1.0f},
                          {2.0f, 1.0f},
                          {1.0f, 2.0f},

                          {0.0f, 0.0f},
                          {1.0f, 0.0f},
                          {0.0f, 1.0f},
                          {0.6f, 0.6f},
                          {1.6f, 0.6f},
                          {0.6f, 1.6f},

                          {0.0f, 0.0f},
                          {1.0f, 0.0f},
                          {0.0f, 1.0f},
                          {0.0f, 1.1f},
                          {1.1f, 0.0f},
                          {3.0f, 3.0f},                         
                         };
            for (int i = 0; i < Tp.Length / 2; i += 6)
            {
                Vector2 p1 = new Vector2(Tp[i + 0, 0], Tp[i + 0, 1]);
                Vector2 q1 = new Vector2(Tp[i + 1, 0], Tp[i + 1, 1]);
                Vector2 r1 = new Vector2(Tp[i + 2, 0], Tp[i + 2, 1]);
                Vector2 p2 = new Vector2(Tp[i + 3, 0], Tp[i + 3, 1]);
                Vector2 q2 = new Vector2(Tp[i + 4, 0], Tp[i + 4, 1]);
                Vector2 r2 = new Vector2(Tp[i + 5, 0], Tp[i + 5, 1]);
                bool result;
                result = IntersectionTest.TriangleTriangleIntersect2D(p1, q1, r1, p2, q2, r2);
                Assert.IsTrue(result);
                result = IntersectionTest.TriangleTriangleIntersect2D(r1, p1, q1, p2, r2, q2);
                Assert.IsTrue(result);
                result = IntersectionTest.TriangleTriangleIntersect2D(q1, p1, r1, q2, r2, p2);
                Assert.IsTrue(result);
            }

            for (int i = 0; i < Tn.Length / 2; i += 6)
            {
                Vector2 p1 = new Vector2(Tn[i + 0, 0], Tn[i + 0, 1]);
                Vector2 q1 = new Vector2(Tn[i + 1, 0], Tn[i + 1, 1]);
                Vector2 r1 = new Vector2(Tn[i + 2, 0], Tn[i + 2, 1]);
                Vector2 p2 = new Vector2(Tn[i + 3, 0], Tn[i + 3, 1]);
                Vector2 q2 = new Vector2(Tn[i + 4, 0], Tn[i + 4, 1]);
                Vector2 r2 = new Vector2(Tn[i + 5, 0], Tn[i + 5, 1]);
                bool result;
                result = IntersectionTest.TriangleTriangleIntersect2D(p1, q1, r1, p2, q2, r2);
                Assert.IsFalse(result);
                result = IntersectionTest.TriangleTriangleIntersect2D(r1, p1, q1, p2, r2, q2);
                Assert.IsFalse(result);
                result = IntersectionTest.TriangleTriangleIntersect2D(q1, p1, r1, q2, r2, p2);
                Assert.IsFalse(result);
            }
        }
    }
}
