﻿namespace Tests
{
    using System;
    using System.Text;
    using System.Threading;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using System.Net.NetworkInformation;
    using NewGamePhysics.Networking;

    /// <summary>
    /// Summary description for UnitTestHighResolutionTimer
    /// </summary>
    [TestClass]
    public class UnitTestPlayTrulyRandom
    {
        static PlayTrulyRandom ptr = null;

        public UnitTestPlayTrulyRandom()
        {
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        [ClassInitialize()]
        public static void PlayTrulyRandomInit(TestContext testContext)
        {
            ptr = null;
            string agentName = "test";
            string userName = Guid.NewGuid().ToString();
            try
            {
                ptr = new PlayTrulyRandom(agentName, userName, 8);
                Console.WriteLine("PlayTrulyRandom('{0}','{1}')", agentName, userName);
                Assert.IsNotNull(ptr, "ptr");

                // Test read to check if we have connectivity
                int retrievedBits;
                int randomNumber = ptr.Next(0, 1, out retrievedBits);
            }
            catch (Exception e)
            {
                if (e.Message.Contains("Could not retrieve"))
                {
                    // assume no internet connectivity
                    ptr = null;
                    return;
                }
                else
                {
                    throw;
                }
            }
        }

        [TestMethod]
        public void PlayTrulyRandomNextValidRange()
        {
            const int NumTests = 20;
            const int NumRepeats = 5;
            int[] min = new int[NumTests];
            int[] max = new int[NumTests];

            // skip test if we are not connected
            if (ptr == null)
            {
                return;
            }

            // Some specific test values
            int t = 0;
            min[t] =  0;
            max[t] =  0;
            t++;
            min[t] = 0;
            max[t] = 1;
            t++;
            min[t] = 0;
            max[t] = 2;
            t++;
            min[t] = -1;
            max[t] = 0;
            t++;
            min[t] = -1;
            max[t] = 1;
            t++;
            min[t] = -2;
            max[t] = -2;
            t++;
            min[t] = -2;
            max[t] = -1;
            t++;
            min[t] = 2;
            max[t] = 2;
            t++;
            min[t] = -2;
            max[t] = 2;
            t++;
            min[t] = int.MinValue;
            max[t] = int.MaxValue;
            t++;
            
            // Generate additional bounds at random
            // in the byte range
            Random rnd = new Random();
            for (int i = t; i < NumTests; i++)
            {
                min[i] = rnd.Next(0, byte.MaxValue);
                max[i] = rnd.Next(min[i], min[i] + byte.MaxValue);
            }

            // Generate random numbers and test them
            for (int i = 0; i < NumTests; i++)
            {
                for (int j = 0; j < NumRepeats; j++)
                {
                    int retrievedBits;
                    int randomNumber = ptr.Next(min[i], max[i], out retrievedBits);
                    Console.WriteLine("Test_{3}.{4}: Next({0},{1}) = {2}", min[i], max[i], randomNumber, i+1, j+1);
                    Assert.IsTrue(randomNumber >= min[i]);
                    Assert.IsTrue(randomNumber <= max[i]);
                }

                Console.WriteLine("");
            }
        }
    }
}


