<?php

/* 
 playtrulyrandom.com Webservice Component
 (c) A. Schiffler, 2008-2010, GPL
 
 data.php - Retrieve the latest entropy pool data as raw binary blob.
*/

include ("config.inc.php");

/* make DB connection */
$mysqli = new mysqli($sconfig['server'], $config['user'], $config['password'], $config['database']);

/* check connection */
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
} 

/* get source name */
$sourcename = $_REQUEST["source"];
if (!$sourcename)
{
   printf("");
   exit(0);
}

/* reference position for bits reader */
$lastbitsid=0;
$lastbitsindex=0;

/* Find sourceid, bits marker */
$sourceid=0;
$sourcename = $mysqli->real_escape_string ($sourcename);
$query = sprintf("SELECT sourceid FROM source WHERE name='%s'", $sourcename);
if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $sourceid = $row["sourceid"];
   }
   $result->close();
}

/* do we have a source now? */ 
if (!$sourceid)
{
      printf("");
      exit(0);
}

/* count hits on source */
$query = sprintf("UPDATE source SET hits=hits+1 WHERE sourceid=%d",$sourceid);   
if (!($result = $mysqli->query($query))) {
      printf("0");
      exit(0);
}

/* how many bits were requested*/ 
$bytesRequested=$_REQUEST["n"] + 0; 
if ($bytesRequested<1)
{
   printf("");
   exit();
}

/* limit request to 1Mbyte */
if ($bytesRequested>1024*1024) {
   $bytesRequested = 1024*1024;
}
$bitsRequested=$bytesRequested * 8;

/* Retrieve last submission ID of source */
$query = sprintf("SELECT bitsid AS lastId FROM bits WHERE sourceid=%d ORDER BY bitsid DESC LIMIT 1", $sourceid);
if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $lastId = $row["lastId"];
   }
   $result->close();
}

/* loop to fill bits request */
$bitsLen = 0;
$bitsBucket = "";

/* do we need more bits */
while ($bitsLen < $bitsRequested) {
   /* add bits from records we have not retrieved yet */
   $query = sprintf("SELECT bitsid,data FROM bits WHERE bitsid<%d AND sourceid=%d ORDER BY bitsid DESC LIMIT 1", $lastId, $sourceid);
   if ($result = $mysqli->query($query)) {
      if ($row = $result->fetch_assoc()) {
         /* add these bits to the bucket */
         $bitsBucket .= $row["data"];
         $bitsLen = strlen($bitsBucket);         
         $lastId = $row["bitsid"];         
      } else {
         /* return what we've got */
         $bitsLen = $bitsRequested;
      }
      $result->close();
   }
}

/* did we read enough bits? determine bits to send */
$bitsLen = strlen($bitsBucket);
if ($bitsLen < $bitsRequested) {
   /* adjust to actual length */
   $bitsToSend = $bitsLen;
} else {
   /* send what was requested */
   $bitsToSend = $bitsRequested;
}

/* close connection */
$mysqli->close();

/* convert bit string into binary blob */
$binary = "";
for ($pos=0; $pos<$bitsToSend; $pos += 8)
{
 $byteBits = substr($bitsBucket, $pos, 8);
 $number = bindec($byteBits);
 $binary .= pack("c", $number);
}

/* HTTP header for binary data */
$bytesToSend = $bitsToSend / 8;
header("Content-Type: application/octet-stream");
header("Content-Disposition: attachment; filename=\"entropy.dat\"");
header("Content-Length: " . $bytesToSend);

echo $binary;
?>
