<?php

/* 
 playtrulyrandom.com Webservice Component
 (c) A. Schiffler, 2008-2010, GPL
 
 display.php - Generates a black and white image from entropy pool data. 
*/

include ("config.inc.php");

/* make DB connection */
$mysqli = new mysqli($sconfig['server'], $config['user'], $config['password'], $config['database']);

/* check connection */
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

/* reset data */
$data = "";

/* get source name, use default if needed */
$id = $_REQUEST["id"] + 0;
if ($id)
{
 /* Retrieve some data from bits-store */
 $query = sprintf("SELECT data FROM bits WHERE bitsid=%d", $id);
 if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $data = $row["data"];
   }
   $result->close();
 }
}

// Blocksize
$size=6;

// Create a new image instance
$width=$size*strlen($data);
$height=$size;

$canvas = imagecreatetruecolor($width+2, $height+2);

// Allocate colors
$black = imagecolorallocate($canvas, 0, 0, 0);
$white = imagecolorallocate($canvas, 255, 255, 255);
$gray = imagecolorallocate($canvas, 222, 222, 222);

// Frame
imagerectangle($canvas, 0, 0, $width+1, $height+1, $gray);
imagefilledrectangle($canvas, 1, 1, $width, $height, $white);

// Bits
$xpos=1;
$bits=$data;

$bitsLen = strlen($bits);
for ($i=0; $i<$bitsLen; $i++) {
   $nextBit = $bits{$i};
   if ($nextBit == "0") {
    $curColor = $black;
   } else {
    $curColor = $white;
   }
   imagefilledrectangle($canvas, $xpos, 1, $xpos+$size, $size ,$curColor);
   $xpos += $size;
}

// Handle output
if(function_exists('imagegif')) {
    // For GIF
    header('Content-type: image/gif');
    imagegif($canvas);
}
imagedestroy($canvas);

?>
