<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Play Truly Random - Physical Entropy for and from Games</title>
<style type="text/css">
body {
	background-image: url(images/random_bands.gif);
	margin-left: 0px;
	margin-top: 0px;
	margin-right: 0px;
	margin-bottom: 0px;
}
#content {
	width : 720px;
	position : absolute;
	top : 0px;
	left : 100px;
	padding : 30px;
	font-family: sans-serif;
	font-size: 12px;
	}
#footer {
	font-family: serif;
	font-size: 10px;
	}
</style>
</head>
<body>
<div id="content">
<h1>Play Truly Random</h1>
<h3>Physical Entropy for and from Games</h3>
<p>
Digital computers are completely deterministic, yet they are often consumers of randomness for example
in games, cryptography, simulations, or science experiments just to name a few uses. To produce
randomness which can be used by software, programmers implement special mathematical algorithms to
generate a series of numbers which <i>appear</i> random: pseudorandom numbers.
</p>
<p>
But a true source of randomness is all around us, ready to be tapped: the physical reality of the very
small and the very complex. This webservice proposes a new facet of "Game Physics", which is to provide
physics based random bits for games and interactive media as well as to derive randomness from
game processes. 
</p>
<p>
Even though games are the earliest methods of generating real random numbers from mechanical
systems through dice, coin flipping, roulette wheels etc., todays computer games and interactive media
tend to make rarely use of the incredible amount of randomness which surrounds us. One simple way
to make digital games more realistic - maybe better - is by simply replacing the pseudo random number
generators (PRNGs) with the real thing: a physical entropy source.
</p>
<p>
It is useful to introduce the term Entropy, which can be though of as
<i title="[Chang, Raymond (1998). Chemistry, 6th Ed.. New York: McGraw Hill.]">a direct measure of the
randomness of a system</i>. Although many pseudorandom number generators use an
<i>Entropy Pool</i> - a collection of bits derived from "random" events in the computer system such
as network card interrupts - to seed the PRNG in an effort to make it better, the processes feeding
into this pool tend to be well removed from any physical reality which created the entropy in the first place.
A better solution for games is to use real physical random bits such as these provided by this webservice.
</p>
<p>
So what are some physical phenomena giving rise to randomness? While many mechanical phenomena
seem to be random, they also feature asymmetries and systematic biases which make their outcome
less random than they seem (and thus for example exploitable by gamblers).
Accepted sources which are truly random are at their core physical and the most comon are
quantum mechanical in nature: thermal noise analog electronic circuits, the radioactive
decay, atmospheric shot noise. 
</p>
&nbsp;<br />
<h3>Current Status of Bit Pool</h3>
<p>
<?php
 include "status.php";
?>
</p>
&nbsp;<br />
<h3>Retrieving and Submitting Random Bits</h3>
<p>
<a href="api.html">Click here</a> to see the API for this webservice.</a>
</p>
&nbsp;<br />
&nbsp;<br />
&nbsp;<br />
<div id="footer">
&copy; 2008-<?php echo date('Y'); ?> - Andy, webmaster (at) playtrulyrandom (dot) com
</div>
</div>
</body>
</html>

