<?php

/* 
 playtrulyrandom.com Webservice Component
 (c) A. Schiffler, 2008-2010, GPL
 
 retrieve.php - Retrieve entropy pool data as string of 0/1 characters.
*/

include ("config.inc.php");

/* make DB connection */
$mysqli = new mysqli($sconfig['server'], $config['user'], $config['password'], $config['database']);

/* check connection */
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
} 

/* get source name */
$sourcename = $_REQUEST["source"];
if (!$sourcename)
{
   printf("");
   exit(0);
}

/* get user name */
$username = $_REQUEST["user"];
if (!$username)
{
   printf("");
   exit(0);
}

/* reference position for bits reader */
$lastbitsid=0;
$lastbitsindex=0;

/* Find sourceid, bits marker */
$sourceid=0;
$sourcename = $mysqli->real_escape_string ($sourcename);
$query = sprintf("SELECT sourceid FROM source WHERE name='%s'", $sourcename);
if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $sourceid = $row["sourceid"];
   }
   $result->close();
}

/* do we have a source now? */ 
if (!$sourceid)
{
      printf("");
      exit(0);
}

/* count hits on source */
$query = sprintf("UPDATE source SET hits=hits+1 WHERE sourceid=%d",$sourceid);   
if (!($result = $mysqli->query($query))) {
      printf("0");
      exit(0);
}

/* Find userid, bitsmarkers */
$userid = 0;
$username = $mysqli->real_escape_string ($username);
$query = sprintf("SELECT userid,lastbitsid,lastbitsindex FROM user WHERE name='%s'", $username);
if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $userid = $row["userid"];
      $lastbitsid = $row["lastbitsid"];
      $lastbitsindex = $row["lastbitsindex"];
   }
   $result->close();
}

/* have we seen this user? */
if ($userid == 0)
{
   /* create new user entry */
   $query = sprintf("INSERT INTO user (userid,name,lastbitsid,lastbitsindex,timestamp) VALUES (NULL,'%s',0,0,NOW())", $username);
   if ($result = $mysqli->query($query)) {
      $userid = $mysqli->insert_id;
   }   
}

/* do we have a user now? */ 
if (!$userid)
{
      printf("");
      exit(0);
}

/* how many bits were requested*/ 
$bitsRequested=$_REQUEST["n"] + 0; 
if ($bitsRequested<1)
{
   printf("");
   exit();
}

/* limit bits request */
if ($bitsRequested>1024) {
   $bitsRequested = 1024;
}

/* loop to fill bits request */
$bitsLen = 0;
$bitsBucket = "";
/* maybe add bits from last record which we haven't used yet */
if ($lastbitsindex>0) {
   $query = sprintf("SELECT bitsid,data FROM bits WHERE bitsid=%d LIMIT 1", $lastbitsid);
   if ($result = $mysqli->query($query)) {
      if ($row = $result->fetch_assoc()) {
         $bitsid=$row["bitsid"];
         if ($bitsid==$lastbitsid)
         {            
            /* add remaining bits in previous segment to the bucket */
            $lastdatalen = strlen($row["data"]);
            $bitsBucket .= substr($row["data"], $lastbitsindex);
            $bitsLen = strlen($bitsBucket);
         }
      }
   }
   $result->close();
}

/* do we need more bits */
while ($bitsLen < $bitsRequested) {
   /* add bits from records we have not retrieved yet */
   $query = sprintf("SELECT bitsid,data FROM bits WHERE bitsid>%d LIMIT 1", $lastbitsid);
   if ($result = $mysqli->query($query)) {
      if ($row = $result->fetch_assoc()) {
         /* add these bits to the bucket */
         $lastdatalen = strlen($row["data"]);
         $bitsBucket .= $row["data"];
         $bitsLen = strlen($bitsBucket);
         $lastbitsid = $row["bitsid"];
      } else {
         /* return what we've got */
         $bitsLen = $bitsRequested;
      }
      $result->close();
   }
}

/* calculate size of bits we have now */
$bitsLen = strlen($bitsBucket);

/* did we overread? determine segment index */
if ($bitsLen > $bitsRequested)
{
   /* calculate new index for next retrieval */
   $lastbitsindex = $lastdatalen - $bitsLen + $bitsRequested;   
} else {
   /* no need anymore for this segment */
   $lastbitsindex = 0;
}

/* did we read enough bits? determine bits to send */
if ($bitsLen < $bitsRequested) {
   /* adjust to actual length */
   $bitsToSend = $bitsLen;
} else {
   /* send what was requested */
   $bitsToSend = $bitsRequested;
}

/* mix in PRNG numbers to make this returned bit string unique */
$bits="";
$bitsLen = strlen($bitsBucket);
for ($i=0; $i<$bitsToSend; $i++) {
   $nextBit = $bitsBucket{$i};
   if (mt_rand(0,1)) {
      /* keep bits */
      $bits .= $nextBit;
   } else {
      /* flip bits */
      if ($nextBit=="0")
      {
         $bits .= "1";         
      } else {
         $bits .= "0";
      }
   }
   
}

/* return result */
if ($bitsToSend) {
   /* return result */
   printf($bits);
   /* update source record, ignore errors */
   $query = sprintf("UPDATE source SET retrieved=retrieved+%d WHERE sourceid=%d",$bitsToSend,$sourceid);   
   $result = $mysqli->query($query);
   /* update user record, ignore errors */
   $query = sprintf("UPDATE user SET lastbitsid=%d,lastbitsindex=%d WHERE userid=%d",$lastbitsid,$lastbitsindex,$userid);   
   $result = $mysqli->query($query);
}

/* close connection */
$mysqli->close();

?>
