<?php

/* 
 playtrulyrandom.com Webservice Component
 (c) A. Schiffler, 2008-2010, GPL
 
 status.php - Displays the current status of PTR as webpage /w image.
*/

include ("config.inc.php");

/* make DB connection */
$mysqli = new mysqli($sconfig['server'], $config['user'], $config['password'], $config['database']);

/* check connection */
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
} 

/* Retrieve statistics of bits-store */
$query = sprintf("SELECT COUNT(1) AS numData, SUM(datasize) AS numBits FROM bits");
if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $numData = $row["numData"];
      $numBits = $row["numBits"];
   }
   $result->close();
}

/* Retrieve number of sources */
$query = sprintf("SELECT COUNT(DISTINCT name) AS numSources FROM source ORDER BY name");
if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $numSources = $row["numSources"];
   }
   $result->close();
}
 
/* Retrieve last submission ID */
$query = sprintf("SELECT bitsid AS lastId, bits.created AS lastTime, source.name AS lastSource FROM bits LEFT JOIN source ON bits.sourceid=source.sourceid ORDER BY bitsid DESC LIMIT 1");
if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $lastId = $row["lastId"];
      $lastTime = $row["lastTime"];
      $lastSource = $row["lastSource"];
   }
   $result->close();
}

/* close connection */
$mysqli->close();

/* show statistics */
printf("Number of Submissions = %s<br>", $numData);
printf("Number of Bits in Pool = %s<br>", $numBits);
printf("Number of Sources = %s<br>", $numSources);
printf("Last submission on %s from %s<br>", $lastTime, $lastSource);
printf("<img src=\"display.php?id=%s\"><br>", $lastId)
?>
