<?php

/* 
 playtrulyrandom.com Webservice Component
 (c) A. Schiffler, 2008-2010, GPL
 
 submit.php - Submit random bits to the PTR entropy pool.
*/

include ("config.inc.php");

/* make DB connection */
$mysqli = new mysqli($sconfig['server'], $config['user'], $config['password'], $config['database']);

/* check connection */
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
} 

/* get source name */
$sourcename = $_REQUEST["source"];
if (!$sourcename)
{
   printf("0");
   exit(0);
}

/* Find sourceid */
$sourceid=0;
$sourcename = $mysqli->real_escape_string ($sourcename);
$query = sprintf("SELECT sourceid FROM source WHERE name='%s'", $sourcename);
if ($result = $mysqli->query($query)) {
   if ($row = $result->fetch_assoc()) {
      $sourceid = $row["sourceid"];
   }
   $result->close();
}
 
if (!$sourceid)
{
   printf("0");
   exit(0);
}

/* count hits on source */
$query = sprintf("UPDATE source SET hits=hits+1 WHERE sourceid=%d",$sourceid);   
if (!($result = $mysqli->query($query))) {
   printf("0");
   exit(0);
}

/* check if we got any raw bit input */ 
$rawBits=$_REQUEST["bits"]; 
if (!$rawBits)
{
   printf("0");
   exit();
}

/* clean input, keep only 1 and 0  */
$bits="";
$bitsLen = strlen($rawBits);
for ($i=0; $i<$bitsLen; $i++) {
   $nextBit = $rawBits{$i};
   if (($nextBit == "0") || ($nextBit == "1"))
   {
      $bits .= $nextBit;
   }
}

/* check if we have bits left */  
$bitsLen = strlen($bits);
if (!$bitsLen)
{
  printf("0");
  exit();
}

/* determine quality of bitstring */
$quality=0.0;

/* store bits in database */
$bits = $mysqli->real_escape_string ($bits);
$query = sprintf("INSERT INTO bits (bitsid, sourceid, data, datasize, dataquality, created, changed, used) VALUES (NULL, %d, '%s', %d, %f, NOW(), NULL, 0);",
               $sourceid,
               $bits, $bitsLen,
               (float)$quality
            );   
if ($result = $mysqli->query($query)) {
   printf($bitsLen);
   /* count bits submitted on source; ignore errors */
   $query = sprintf("UPDATE source SET submitted=submitted+%d WHERE sourceid=%d",$bitsLen,$sourceid);   
   $result = $mysqli->query($query);
} else {
   printf("0");
}
 
/* close connection */
$mysqli->close();

?>
